/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.Measure;
import org.relaxng.datatype.ValidationContext;

class ListDatatype
extends DatatypeBase
implements Measure {
    private final DatatypeBase itemType;

    ListDatatype(DatatypeBase datatypeBase) {
        this.itemType = datatypeBase;
    }

    Object getValue(String string, ValidationContext validationContext) {
        String[] stringArray = ListDatatype.split(string);
        Object[] objectArray = new Object[stringArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.itemType.getValue(stringArray[n], validationContext);
            if (objectArray[n] == null) {
                return null;
            }
            ++n;
        }
        return objectArray;
    }

    boolean lexicallyAllows(String string) {
        String[] stringArray = ListDatatype.split(string);
        int n = 0;
        while (n < stringArray.length) {
            if (!this.itemType.lexicallyAllows(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean allowsValue(String string, ValidationContext validationContext) {
        String[] stringArray = ListDatatype.split(string);
        int n = 0;
        while (n < stringArray.length) {
            if (!this.itemType.allowsValue(stringArray[n], validationContext)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String[] split(String string) {
        int n = string.length();
        if (n == 0) {
            return new String[0];
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == ' ') {
                ++n2;
            }
            ++n3;
        }
        String[] stringArray = new String[n2];
        int n4 = 0;
        n2 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (string.charAt(n5) == ' ') {
                stringArray[n2++] = string.substring(n4, n5);
                n4 = n5 + 1;
            }
            ++n5;
        }
        stringArray[n2] = string.substring(n4);
        return stringArray;
    }

    Measure getMeasure() {
        return this;
    }

    public int getLength(Object object) {
        return ((Object[])object).length;
    }

    public boolean isContextDependent() {
        return this.itemType.isContextDependent();
    }

    public int getIdType() {
        if (this.itemType.getIdType() == 2) {
            return 3;
        }
        return 0;
    }

    public int valueHashCode(Object object) {
        Object[] objectArray = (Object[])object;
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n ^= this.itemType.valueHashCode(objectArray[n2]);
            ++n2;
        }
        return n;
    }

    public boolean sameValue(Object object, Object object2) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!this.itemType.sameValue(objectArray[n], objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

