/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.ValidatorHandler;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.Name;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements ValidatorHandler {
    private final IdTypeMap idTypeMap;
    private ErrorHandler eh;
    private boolean hadError;
    private boolean complete;
    private Locator locator;
    private final Hashtable table = new Hashtable();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
    }

    public void reset() {
        this.table.clear();
        this.locator = null;
        this.hadError = false;
        this.complete = false;
    }

    public boolean isValidSoFar() {
        return !this.hadError;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.eh;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    void setComplete() {
        this.complete = true;
    }

    public void endDocument() throws SAXException {
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Entry entry = (Entry)this.table.get(string);
            if (entry.hadId) continue;
            Enumeration enumeration2 = entry.idrefLocs.elements();
            while (enumeration2.hasMoreElements()) {
                this.error("missing_id", string, (Locator)enumeration2.nextElement());
            }
        }
        this.setComplete();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Name name = new Name(string, string2);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            Name name2 = new Name(attributes.getURI(n2), attributes.getLocalName(n2));
            int n3 = this.idTypeMap.getIdType(name, name2);
            if (n3 != 0) {
                String[] stringArray = IdSoundnessChecker.split(attributes.getValue(n2));
                switch (n3) {
                    case 1: {
                        if (stringArray.length == 1) {
                            this.id(stringArray[0]);
                            break;
                        }
                        if (stringArray.length == 0) {
                            this.error("id_no_tokens");
                            break;
                        }
                        this.error("id_multiple_tokens");
                        break;
                    }
                    case 2: {
                        if (stringArray.length == 1) {
                            this.idref(stringArray[0]);
                            break;
                        }
                        if (stringArray.length == 0) {
                            this.error("idref_no_tokens");
                            break;
                        }
                        this.error("idref_multiple_tokens");
                        break;
                    }
                    case 3: {
                        if (stringArray.length > 0) {
                            int n4 = 0;
                            while (n4 < stringArray.length) {
                                this.idref(stringArray[n4]);
                                ++n4;
                            }
                            break;
                        }
                        this.error("idrefs_no_tokens");
                    }
                }
            }
            ++n2;
        }
    }

    private void id(String string) throws SAXException {
        Entry entry = (Entry)this.table.get(string);
        if (entry == null) {
            entry = new Entry();
            this.table.put(string, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", string);
            this.error("first_id", string, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(this.locator);
        entry.hadId = true;
    }

    private void idref(String string) {
        Entry entry = (Entry)this.table.get(string);
        if (entry == null) {
            entry = new Entry();
            this.table.put(string, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new Vector();
        }
        entry.idrefLocs.addElement(new LocatorImpl(this.locator));
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    private void error(String string) throws SAXException {
        this.hadError = true;
        if (this.eh != null) {
            this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string), this.locator));
        }
    }

    private void error(String string, String string2) throws SAXException {
        this.hadError = true;
        if (this.eh != null) {
            this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), this.locator));
        }
    }

    private void error(String string, String string2, Locator locator) throws SAXException {
        this.hadError = true;
        if (this.eh != null) {
            this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string, string2), locator));
        }
    }

    private static String[] split(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!IdSoundnessChecker.isSpace(string.charAt(n3)) && (n3 == 0 || IdSoundnessChecker.isSpace(string.charAt(n3 - 1)))) {
                ++n2;
            }
            ++n3;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n) {
            if (IdSoundnessChecker.isSpace(string.charAt(n5))) {
                if (n4 >= 0) {
                    stringArray[n2++] = string.substring(n4, n5);
                    n4 = -1;
                }
            } else if (n5 == 0 || IdSoundnessChecker.isSpace(string.charAt(n5 - 1))) {
                n4 = n5;
            }
            ++n5;
        }
        if (n4 >= 0) {
            stringArray[n2] = string.substring(n4, n);
        }
        return stringArray;
    }

    private static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static class Entry {
        Locator idLoc;
        Vector idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

