/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.relaxng.util.ErrorHandlerImpl;
import com.thaiopensource.relaxng.util.Jaxp11XMLReaderCreator;
import com.thaiopensource.relaxng.util.ValidationEngine;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

public class JingTask
extends Task {
    private File rngFile;
    private File src;
    private final Vector filesets = new Vector();
    private boolean checkid = true;
    private boolean compactsyntax = false;

    public void execute() throws BuildException {
        if (this.rngFile == null) {
            throw new BuildException("rngFile attribute must be set!", this.location);
        }
        if (this.src == null && this.filesets.size() == 0) {
            throw new BuildException("There must be a file attribute or a fileset child element", this.location);
        }
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(new PrintStream((OutputStream)new LogOutputStream((Task)this, 1)));
        boolean bl = false;
        try {
            ValidationEngine validationEngine = new ValidationEngine(new Jaxp11XMLReaderCreator(), errorHandlerImpl, this.checkid, this.compactsyntax);
            if (!validationEngine.loadSchema(ValidationEngine.fileInputSource(this.rngFile))) {
                bl = true;
            } else {
                if (this.src != null && !validationEngine.validate(ValidationEngine.fileInputSource(this.src))) {
                    bl = true;
                }
                int n = 0;
                while (n < this.filesets.size()) {
                    FileSet fileSet = (FileSet)this.filesets.elementAt(n);
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(((ProjectComponent)this).project);
                    File file = fileSet.getDir(((ProjectComponent)this).project);
                    String[] stringArray = directoryScanner.getIncludedFiles();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (!validationEngine.validate(ValidationEngine.fileInputSource(new File(file, stringArray[n2])))) {
                            bl = true;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (SAXException sAXException) {
            bl = true;
            errorHandlerImpl.printException(sAXException);
        }
        catch (IOException iOException) {
            bl = true;
            errorHandlerImpl.printException(iOException);
        }
        if (bl) {
            throw new BuildException("Validation failed, messages should have been provided.", this.location);
        }
    }

    public void setRngfile(String string) {
        this.rngFile = ((ProjectComponent)this).project.resolveFile(string);
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setCheckid(boolean bl) {
        this.checkid = bl;
    }

    public void setCompactsyntax(boolean bl) {
        this.compactsyntax = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

