/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.relaxng.IncorrectSchemaException;
import com.thaiopensource.relaxng.Schema;
import com.thaiopensource.relaxng.SchemaFactory;
import com.thaiopensource.relaxng.ValidatorHandler;
import com.thaiopensource.relaxng.XMLReaderCreator;
import com.thaiopensource.relaxng.util.DraconianErrorHandler;
import com.thaiopensource.relaxng.util.Sax2XMLReaderCreator;
import com.thaiopensource.util.UriOrFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidationEngine {
    private final XMLReaderCreator xrc;
    private XMLReader xr;
    private final ErrorHandler eh;
    private final SchemaFactory factory;
    private ValidatorHandler vh;
    private Schema schema;

    public ValidationEngine() {
        this(null, null, true);
    }

    public ValidationEngine(XMLReaderCreator xMLReaderCreator, ErrorHandler errorHandler, boolean bl) {
        if (xMLReaderCreator == null) {
            xMLReaderCreator = new Sax2XMLReaderCreator();
        }
        if (errorHandler == null) {
            errorHandler = new DraconianErrorHandler();
        }
        this.factory = new SchemaFactory();
        this.factory.setDatatypeLibraryFactory(new DatatypeLibraryLoader());
        this.xrc = xMLReaderCreator;
        this.factory.setXMLReaderCreator(xMLReaderCreator);
        this.eh = errorHandler;
        this.factory.setErrorHandler(errorHandler);
        this.factory.setCheckIdIdref(bl);
    }

    public ValidationEngine(XMLReaderCreator xMLReaderCreator, ErrorHandler errorHandler, boolean bl, boolean bl2) {
        this(xMLReaderCreator, errorHandler, bl);
        this.factory.setCompactSyntax(bl2);
    }

    public ValidationEngine(XMLReaderCreator xMLReaderCreator, ErrorHandler errorHandler, boolean bl, boolean bl2, boolean bl3) {
        this(xMLReaderCreator, errorHandler, bl, bl2);
        this.factory.setFeasible(bl3);
    }

    public boolean loadSchema(InputSource inputSource) throws SAXException, IOException {
        try {
            this.schema = this.factory.createSchema(inputSource);
            this.vh = null;
            return true;
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            return false;
        }
    }

    public boolean validate(InputSource inputSource) throws SAXException, IOException {
        if (this.schema == null) {
            throw new IllegalStateException("cannot validate without schema");
        }
        if (this.vh == null) {
            this.vh = this.schema.createValidator(this.eh);
        } else {
            this.vh.reset();
        }
        if (this.xr == null) {
            this.xr = this.xrc.createXMLReader();
            if (this.eh != null) {
                this.xr.setErrorHandler(this.eh);
            }
        }
        this.xr.setContentHandler(this.vh);
        this.xr.setDTDHandler(this.vh);
        this.xr.parse(inputSource);
        return this.vh.isValidSoFar();
    }

    public static InputSource fileInputSource(String string) throws MalformedURLException {
        return ValidationEngine.fileInputSource(new File(string));
    }

    public static InputSource fileInputSource(File file) throws MalformedURLException {
        return new InputSource(UriOrFile.fileToUri(file));
    }

    public static InputSource uriOrFileInputSource(String string) throws MalformedURLException {
        return new InputSource(UriOrFile.toUri(string));
    }
}

